package zio.aws.iotsitewise.model
import scala.jdk.CollectionConverters.*
sealed trait DisassociatedDataStorageState {
  def unwrap: software.amazon.awssdk.services.iotsitewise.model.DisassociatedDataStorageState
}
object DisassociatedDataStorageState {
  def wrap(
      value: software.amazon.awssdk.services.iotsitewise.model.DisassociatedDataStorageState
  ): zio.aws.iotsitewise.model.DisassociatedDataStorageState = value match {
    case software.amazon.awssdk.services.iotsitewise.model.DisassociatedDataStorageState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotsitewise.model.DisassociatedDataStorageState.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.iotsitewise.model.DisassociatedDataStorageState.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotsitewise.model.DisassociatedDataStorageState {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.DisassociatedDataStorageState =
      software.amazon.awssdk.services.iotsitewise.model.DisassociatedDataStorageState.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED
      extends zio.aws.iotsitewise.model.DisassociatedDataStorageState {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.DisassociatedDataStorageState =
      software.amazon.awssdk.services.iotsitewise.model.DisassociatedDataStorageState.ENABLED
  }
  case object DISABLED
      extends zio.aws.iotsitewise.model.DisassociatedDataStorageState {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.DisassociatedDataStorageState =
      software.amazon.awssdk.services.iotsitewise.model.DisassociatedDataStorageState.DISABLED
  }
}
