package zio.aws.iotsitewise.model
import scala.jdk.CollectionConverters.*
sealed trait EncryptionType {
  def unwrap: software.amazon.awssdk.services.iotsitewise.model.EncryptionType
}
object EncryptionType {
  def wrap(
      value: software.amazon.awssdk.services.iotsitewise.model.EncryptionType
  ): zio.aws.iotsitewise.model.EncryptionType = value match {
    case software.amazon.awssdk.services.iotsitewise.model.EncryptionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotsitewise.model.EncryptionType.SITEWISE_DEFAULT_ENCRYPTION =>
      val r = SITEWISE_DEFAULT_ENCRYPTION
      r
    case software.amazon.awssdk.services.iotsitewise.model.EncryptionType.KMS_BASED_ENCRYPTION =>
      val r = KMS_BASED_ENCRYPTION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotsitewise.model.EncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.EncryptionType =
      software.amazon.awssdk.services.iotsitewise.model.EncryptionType.UNKNOWN_TO_SDK_VERSION
  }
  case object SITEWISE_DEFAULT_ENCRYPTION
      extends zio.aws.iotsitewise.model.EncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.EncryptionType =
      software.amazon.awssdk.services.iotsitewise.model.EncryptionType.SITEWISE_DEFAULT_ENCRYPTION
  }
  case object KMS_BASED_ENCRYPTION
      extends zio.aws.iotsitewise.model.EncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.EncryptionType =
      software.amazon.awssdk.services.iotsitewise.model.EncryptionType.KMS_BASED_ENCRYPTION
  }
}
