package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ForwardingConfig(
    state: zio.aws.iotsitewise.model.ForwardingConfigState
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ForwardingConfig = {
    import ForwardingConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ForwardingConfig
      .builder()
      .state(state.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.ForwardingConfig.ReadOnly =
    zio.aws.iotsitewise.model.ForwardingConfig.wrap(buildAwsValue())
}
object ForwardingConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ForwardingConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ForwardingConfig =
      zio.aws.iotsitewise.model.ForwardingConfig(state)
    def state: zio.aws.iotsitewise.model.ForwardingConfigState
    def getState
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.ForwardingConfigState] =
      ZIO.succeed(state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ForwardingConfig
  ) extends zio.aws.iotsitewise.model.ForwardingConfig.ReadOnly {
    override val state: zio.aws.iotsitewise.model.ForwardingConfigState =
      zio.aws.iotsitewise.model.ForwardingConfigState.wrap(impl.state())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ForwardingConfig
  ): zio.aws.iotsitewise.model.ForwardingConfig.ReadOnly = new Wrapper(impl)
}
