package zio.aws.iotsitewise.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotsitewise.model.primitives.{
  NextToken,
  AssetPropertyAlias,
  Timestamp,
  MaxResults,
  ID
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetAssetPropertyValueHistoryRequest(
    assetId: Optional[ID] = Optional.Absent,
    propertyId: Optional[ID] = Optional.Absent,
    propertyAlias: Optional[AssetPropertyAlias] = Optional.Absent,
    startDate: Optional[Timestamp] = Optional.Absent,
    endDate: Optional[Timestamp] = Optional.Absent,
    qualities: Optional[Iterable[zio.aws.iotsitewise.model.Quality]] =
      Optional.Absent,
    timeOrdering: Optional[zio.aws.iotsitewise.model.TimeOrdering] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryRequest = {
    import GetAssetPropertyValueHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryRequest
      .builder()
      .optionallyWith(assetId.map(value => ID.unwrap(value): java.lang.String))(
        _.assetId
      )
      .optionallyWith(
        propertyId.map(value => ID.unwrap(value): java.lang.String)
      )(_.propertyId)
      .optionallyWith(
        propertyAlias.map(value =>
          AssetPropertyAlias.unwrap(value): java.lang.String
        )
      )(_.propertyAlias)
      .optionallyWith(startDate.map(value => Timestamp.unwrap(value): Instant))(
        _.startDate
      )
      .optionallyWith(endDate.map(value => Timestamp.unwrap(value): Instant))(
        _.endDate
      )
      .optionallyWith(
        qualities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.qualitiesWithStrings)
      .optionallyWith(timeOrdering.map(value => value.unwrap))(_.timeOrdering)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.GetAssetPropertyValueHistoryRequest.ReadOnly =
    zio.aws.iotsitewise.model.GetAssetPropertyValueHistoryRequest
      .wrap(buildAwsValue())
}
object GetAssetPropertyValueHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.GetAssetPropertyValueHistoryRequest =
      zio.aws.iotsitewise.model.GetAssetPropertyValueHistoryRequest(
        assetId.map(value => value),
        propertyId.map(value => value),
        propertyAlias.map(value => value),
        startDate.map(value => value),
        endDate.map(value => value),
        qualities.map(value => value),
        timeOrdering.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def assetId: Optional[ID]
    def propertyId: Optional[ID]
    def propertyAlias: Optional[AssetPropertyAlias]
    def startDate: Optional[Timestamp]
    def endDate: Optional[Timestamp]
    def qualities: Optional[List[zio.aws.iotsitewise.model.Quality]]
    def timeOrdering: Optional[zio.aws.iotsitewise.model.TimeOrdering]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getAssetId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("assetId", assetId)
    def getPropertyId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("propertyId", propertyId)
    def getPropertyAlias: ZIO[Any, AwsError, AssetPropertyAlias] =
      AwsError.unwrapOptionField("propertyAlias", propertyAlias)
    def getStartDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getEndDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getQualities
        : ZIO[Any, AwsError, List[zio.aws.iotsitewise.model.Quality]] =
      AwsError.unwrapOptionField("qualities", qualities)
    def getTimeOrdering
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.TimeOrdering] =
      AwsError.unwrapOptionField("timeOrdering", timeOrdering)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryRequest
  ) extends zio.aws.iotsitewise.model.GetAssetPropertyValueHistoryRequest.ReadOnly {
    override val assetId: Optional[ID] = zio.aws.core.internal
      .optionalFromNullable(impl.assetId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val propertyId: Optional[ID] = zio.aws.core.internal
      .optionalFromNullable(impl.propertyId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val propertyAlias: Optional[AssetPropertyAlias] =
      zio.aws.core.internal
        .optionalFromNullable(impl.propertyAlias())
        .map(value =>
          zio.aws.iotsitewise.model.primitives.AssetPropertyAlias(value)
        )
    override val startDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startDate())
      .map(value => zio.aws.iotsitewise.model.primitives.Timestamp(value))
    override val endDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endDate())
      .map(value => zio.aws.iotsitewise.model.primitives.Timestamp(value))
    override val qualities: Optional[List[zio.aws.iotsitewise.model.Quality]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.qualities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotsitewise.model.Quality.wrap(item)
          }.toList
        )
    override val timeOrdering
        : Optional[zio.aws.iotsitewise.model.TimeOrdering] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeOrdering())
        .map(value => zio.aws.iotsitewise.model.TimeOrdering.wrap(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iotsitewise.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryRequest
  ): zio.aws.iotsitewise.model.GetAssetPropertyValueHistoryRequest.ReadOnly =
    new Wrapper(impl)
}
