package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{AssetPropertyAlias, ID}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetAssetPropertyValueRequest(
    assetId: Optional[ID] = Optional.Absent,
    propertyId: Optional[ID] = Optional.Absent,
    propertyAlias: Optional[AssetPropertyAlias] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueRequest = {
    import GetAssetPropertyValueRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueRequest
      .builder()
      .optionallyWith(assetId.map(value => ID.unwrap(value): java.lang.String))(
        _.assetId
      )
      .optionallyWith(
        propertyId.map(value => ID.unwrap(value): java.lang.String)
      )(_.propertyId)
      .optionallyWith(
        propertyAlias.map(value =>
          AssetPropertyAlias.unwrap(value): java.lang.String
        )
      )(_.propertyAlias)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.GetAssetPropertyValueRequest.ReadOnly =
    zio.aws.iotsitewise.model.GetAssetPropertyValueRequest.wrap(buildAwsValue())
}
object GetAssetPropertyValueRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.GetAssetPropertyValueRequest =
      zio.aws.iotsitewise.model.GetAssetPropertyValueRequest(
        assetId.map(value => value),
        propertyId.map(value => value),
        propertyAlias.map(value => value)
      )
    def assetId: Optional[ID]
    def propertyId: Optional[ID]
    def propertyAlias: Optional[AssetPropertyAlias]
    def getAssetId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("assetId", assetId)
    def getPropertyId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("propertyId", propertyId)
    def getPropertyAlias: ZIO[Any, AwsError, AssetPropertyAlias] =
      AwsError.unwrapOptionField("propertyAlias", propertyAlias)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueRequest
  ) extends zio.aws.iotsitewise.model.GetAssetPropertyValueRequest.ReadOnly {
    override val assetId: Optional[ID] = zio.aws.core.internal
      .optionalFromNullable(impl.assetId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val propertyId: Optional[ID] = zio.aws.core.internal
      .optionalFromNullable(impl.propertyId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val propertyAlias: Optional[AssetPropertyAlias] =
      zio.aws.core.internal
        .optionalFromNullable(impl.propertyAlias())
        .map(value =>
          zio.aws.iotsitewise.model.primitives.AssetPropertyAlias(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueRequest
  ): zio.aws.iotsitewise.model.GetAssetPropertyValueRequest.ReadOnly =
    new Wrapper(impl)
}
