package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetInterpolatedAssetPropertyValuesResponse(
    interpolatedAssetPropertyValues: Iterable[
      zio.aws.iotsitewise.model.InterpolatedAssetPropertyValue
    ],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesResponse = {
    import GetInterpolatedAssetPropertyValuesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesResponse
      .builder()
      .interpolatedAssetPropertyValues(interpolatedAssetPropertyValues.map {
        item =>
          item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.GetInterpolatedAssetPropertyValuesResponse.ReadOnly =
    zio.aws.iotsitewise.model.GetInterpolatedAssetPropertyValuesResponse
      .wrap(buildAwsValue())
}
object GetInterpolatedAssetPropertyValuesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.GetInterpolatedAssetPropertyValuesResponse =
      zio.aws.iotsitewise.model.GetInterpolatedAssetPropertyValuesResponse(
        interpolatedAssetPropertyValues.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def interpolatedAssetPropertyValues: List[
      zio.aws.iotsitewise.model.InterpolatedAssetPropertyValue.ReadOnly
    ]
    def nextToken: Optional[NextToken]
    def getInterpolatedAssetPropertyValues: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.InterpolatedAssetPropertyValue.ReadOnly
    ]] = ZIO.succeed(interpolatedAssetPropertyValues)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesResponse
  ) extends zio.aws.iotsitewise.model.GetInterpolatedAssetPropertyValuesResponse.ReadOnly {
    override val interpolatedAssetPropertyValues: List[
      zio.aws.iotsitewise.model.InterpolatedAssetPropertyValue.ReadOnly
    ] = impl
      .interpolatedAssetPropertyValues()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.InterpolatedAssetPropertyValue.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesResponse
  ): zio.aws.iotsitewise.model.GetInterpolatedAssetPropertyValuesResponse.ReadOnly =
    new Wrapper(impl)
}
