package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.ARN
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Greengrass(groupArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.Greengrass = {
    import Greengrass.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.Greengrass
      .builder()
      .groupArn(ARN.unwrap(groupArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.Greengrass.ReadOnly =
    zio.aws.iotsitewise.model.Greengrass.wrap(buildAwsValue())
}
object Greengrass {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.Greengrass
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.Greengrass =
      zio.aws.iotsitewise.model.Greengrass(groupArn)
    def groupArn: ARN
    def getGroupArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(groupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.Greengrass
  ) extends zio.aws.iotsitewise.model.Greengrass.ReadOnly {
    override val groupArn: ARN =
      zio.aws.iotsitewise.model.primitives.ARN(impl.groupArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.Greengrass
  ): zio.aws.iotsitewise.model.Greengrass.ReadOnly = new Wrapper(impl)
}
