package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.ID
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Image(
    id: Optional[ID] = Optional.Absent,
    file: Optional[zio.aws.iotsitewise.model.ImageFile] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.Image = {
    import Image.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.Image
      .builder()
      .optionallyWith(id.map(value => ID.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(file.map(value => value.buildAwsValue()))(_.file)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.Image.ReadOnly =
    zio.aws.iotsitewise.model.Image.wrap(buildAwsValue())
}
object Image {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iotsitewise.model.Image] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.Image = zio.aws.iotsitewise.model
      .Image(id.map(value => value), file.map(value => value.asEditable))
    def id: Optional[ID]
    def file: Optional[zio.aws.iotsitewise.model.ImageFile.ReadOnly]
    def getId: ZIO[Any, AwsError, ID] = AwsError.unwrapOptionField("id", id)
    def getFile
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.ImageFile.ReadOnly] =
      AwsError.unwrapOptionField("file", file)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.Image
  ) extends zio.aws.iotsitewise.model.Image.ReadOnly {
    override val id: Optional[ID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val file: Optional[zio.aws.iotsitewise.model.ImageFile.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.file())
        .map(value => zio.aws.iotsitewise.model.ImageFile.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.Image
  ): zio.aws.iotsitewise.model.Image.ReadOnly = new Wrapper(impl)
}
