package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class InterpolatedAssetPropertyValue(
    timestamp: zio.aws.iotsitewise.model.TimeInNanos,
    value: zio.aws.iotsitewise.model.Variant
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.InterpolatedAssetPropertyValue = {
    import InterpolatedAssetPropertyValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.InterpolatedAssetPropertyValue
      .builder()
      .timestamp(timestamp.buildAwsValue())
      .value(value.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.InterpolatedAssetPropertyValue.ReadOnly =
    zio.aws.iotsitewise.model.InterpolatedAssetPropertyValue
      .wrap(buildAwsValue())
}
object InterpolatedAssetPropertyValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.InterpolatedAssetPropertyValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.InterpolatedAssetPropertyValue =
      zio.aws.iotsitewise.model
        .InterpolatedAssetPropertyValue(timestamp.asEditable, value.asEditable)
    def timestamp: zio.aws.iotsitewise.model.TimeInNanos.ReadOnly
    def value: zio.aws.iotsitewise.model.Variant.ReadOnly
    def getTimestamp
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.TimeInNanos.ReadOnly] =
      ZIO.succeed(timestamp)
    def getValue
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.Variant.ReadOnly] =
      ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.InterpolatedAssetPropertyValue
  ) extends zio.aws.iotsitewise.model.InterpolatedAssetPropertyValue.ReadOnly {
    override val timestamp: zio.aws.iotsitewise.model.TimeInNanos.ReadOnly =
      zio.aws.iotsitewise.model.TimeInNanos.wrap(impl.timestamp())
    override val value: zio.aws.iotsitewise.model.Variant.ReadOnly =
      zio.aws.iotsitewise.model.Variant.wrap(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.InterpolatedAssetPropertyValue
  ): zio.aws.iotsitewise.model.InterpolatedAssetPropertyValue.ReadOnly =
    new Wrapper(impl)
}
