package zio.aws.iotsitewise.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotsitewise.model.primitives.{
  NextToken,
  IdentityId,
  MaxResults,
  ARN,
  ID
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListAccessPoliciesRequest(
    identityType: Optional[zio.aws.iotsitewise.model.IdentityType] =
      Optional.Absent,
    identityId: Optional[IdentityId] = Optional.Absent,
    resourceType: Optional[zio.aws.iotsitewise.model.ResourceType] =
      Optional.Absent,
    resourceId: Optional[ID] = Optional.Absent,
    iamArn: Optional[ARN] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesRequest = {
    import ListAccessPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesRequest
      .builder()
      .optionallyWith(identityType.map(value => value.unwrap))(_.identityType)
      .optionallyWith(
        identityId.map(value => IdentityId.unwrap(value): java.lang.String)
      )(_.identityId)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        resourceId.map(value => ID.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(iamArn.map(value => ARN.unwrap(value): java.lang.String))(
        _.iamArn
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.ListAccessPoliciesRequest.ReadOnly =
    zio.aws.iotsitewise.model.ListAccessPoliciesRequest.wrap(buildAwsValue())
}
object ListAccessPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ListAccessPoliciesRequest =
      zio.aws.iotsitewise.model.ListAccessPoliciesRequest(
        identityType.map(value => value),
        identityId.map(value => value),
        resourceType.map(value => value),
        resourceId.map(value => value),
        iamArn.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def identityType: Optional[zio.aws.iotsitewise.model.IdentityType]
    def identityId: Optional[IdentityId]
    def resourceType: Optional[zio.aws.iotsitewise.model.ResourceType]
    def resourceId: Optional[ID]
    def iamArn: Optional[ARN]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getIdentityType
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.IdentityType] =
      AwsError.unwrapOptionField("identityType", identityType)
    def getIdentityId: ZIO[Any, AwsError, IdentityId] =
      AwsError.unwrapOptionField("identityId", identityId)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getIamArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("iamArn", iamArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesRequest
  ) extends zio.aws.iotsitewise.model.ListAccessPoliciesRequest.ReadOnly {
    override val identityType
        : Optional[zio.aws.iotsitewise.model.IdentityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityType())
        .map(value => zio.aws.iotsitewise.model.IdentityType.wrap(value))
    override val identityId: Optional[IdentityId] = zio.aws.core.internal
      .optionalFromNullable(impl.identityId())
      .map(value => zio.aws.iotsitewise.model.primitives.IdentityId(value))
    override val resourceType
        : Optional[zio.aws.iotsitewise.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.iotsitewise.model.ResourceType.wrap(value))
    override val resourceId: Optional[ID] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val iamArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.iamArn())
      .map(value => zio.aws.iotsitewise.model.primitives.ARN(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iotsitewise.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesRequest
  ): zio.aws.iotsitewise.model.ListAccessPoliciesRequest.ReadOnly = new Wrapper(
    impl
  )
}
