package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListProjectsResponse(
    projectSummaries: Iterable[zio.aws.iotsitewise.model.ProjectSummary],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ListProjectsResponse = {
    import ListProjectsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ListProjectsResponse
      .builder()
      .projectSummaries(projectSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.ListProjectsResponse.ReadOnly =
    zio.aws.iotsitewise.model.ListProjectsResponse.wrap(buildAwsValue())
}
object ListProjectsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ListProjectsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ListProjectsResponse =
      zio.aws.iotsitewise.model.ListProjectsResponse(
        projectSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def projectSummaries
        : List[zio.aws.iotsitewise.model.ProjectSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getProjectSummaries: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.ProjectSummary.ReadOnly
    ]] = ZIO.succeed(projectSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListProjectsResponse
  ) extends zio.aws.iotsitewise.model.ListProjectsResponse.ReadOnly {
    override val projectSummaries
        : List[zio.aws.iotsitewise.model.ProjectSummary.ReadOnly] = impl
      .projectSummaries()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.ProjectSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListProjectsResponse
  ): zio.aws.iotsitewise.model.ListProjectsResponse.ReadOnly = new Wrapper(impl)
}
