package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.AmazonResourceName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(resourceArn: AmazonResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(AmazonResourceName.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.iotsitewise.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ListTagsForResourceRequest =
      zio.aws.iotsitewise.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: AmazonResourceName
    def getResourceArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListTagsForResourceRequest
  ) extends zio.aws.iotsitewise.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: AmazonResourceName =
      zio.aws.iotsitewise.model.primitives
        .AmazonResourceName(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListTagsForResourceRequest
  ): zio.aws.iotsitewise.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
