package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListTimeSeriesResponse(
    timeSeriesSummaries: Iterable[zio.aws.iotsitewise.model.TimeSeriesSummary],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesResponse = {
    import ListTimeSeriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesResponse
      .builder()
      .timeSeriesSummaries(timeSeriesSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.ListTimeSeriesResponse.ReadOnly =
    zio.aws.iotsitewise.model.ListTimeSeriesResponse.wrap(buildAwsValue())
}
object ListTimeSeriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ListTimeSeriesResponse =
      zio.aws.iotsitewise.model.ListTimeSeriesResponse(
        timeSeriesSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def timeSeriesSummaries
        : List[zio.aws.iotsitewise.model.TimeSeriesSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getTimeSeriesSummaries: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.TimeSeriesSummary.ReadOnly
    ]] = ZIO.succeed(timeSeriesSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesResponse
  ) extends zio.aws.iotsitewise.model.ListTimeSeriesResponse.ReadOnly {
    override val timeSeriesSummaries
        : List[zio.aws.iotsitewise.model.TimeSeriesSummary.ReadOnly] = impl
      .timeSeriesSummaries()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.TimeSeriesSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesResponse
  ): zio.aws.iotsitewise.model.ListTimeSeriesResponse.ReadOnly = new Wrapper(
    impl
  )
}
