package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class MetricProcessingConfig(
    computeLocation: zio.aws.iotsitewise.model.ComputeLocation
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.MetricProcessingConfig = {
    import MetricProcessingConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.MetricProcessingConfig
      .builder()
      .computeLocation(computeLocation.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.MetricProcessingConfig.ReadOnly =
    zio.aws.iotsitewise.model.MetricProcessingConfig.wrap(buildAwsValue())
}
object MetricProcessingConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.MetricProcessingConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.MetricProcessingConfig =
      zio.aws.iotsitewise.model.MetricProcessingConfig(computeLocation)
    def computeLocation: zio.aws.iotsitewise.model.ComputeLocation
    def getComputeLocation
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.ComputeLocation] =
      ZIO.succeed(computeLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.MetricProcessingConfig
  ) extends zio.aws.iotsitewise.model.MetricProcessingConfig.ReadOnly {
    override val computeLocation: zio.aws.iotsitewise.model.ComputeLocation =
      zio.aws.iotsitewise.model.ComputeLocation.wrap(impl.computeLocation())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.MetricProcessingConfig
  ): zio.aws.iotsitewise.model.MetricProcessingConfig.ReadOnly = new Wrapper(
    impl
  )
}
