package zio.aws.iotsitewise.model
import scala.jdk.CollectionConverters.*
sealed trait Permission {
  def unwrap: software.amazon.awssdk.services.iotsitewise.model.Permission
}
object Permission {
  def wrap(
      value: software.amazon.awssdk.services.iotsitewise.model.Permission
  ): zio.aws.iotsitewise.model.Permission = value match {
    case software.amazon.awssdk.services.iotsitewise.model.Permission.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotsitewise.model.Permission.ADMINISTRATOR =>
      val r = ADMINISTRATOR
      r
    case software.amazon.awssdk.services.iotsitewise.model.Permission.VIEWER =>
      val r = VIEWER
      r
  }
  case object unknownToSdkVersion extends zio.aws.iotsitewise.model.Permission {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.Permission =
      software.amazon.awssdk.services.iotsitewise.model.Permission.UNKNOWN_TO_SDK_VERSION
  }
  case object ADMINISTRATOR extends zio.aws.iotsitewise.model.Permission {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.Permission =
      software.amazon.awssdk.services.iotsitewise.model.Permission.ADMINISTRATOR
  }
  case object VIEWER extends zio.aws.iotsitewise.model.Permission {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.Permission =
      software.amazon.awssdk.services.iotsitewise.model.Permission.VIEWER
  }
}
