package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PortalStatus(
    state: zio.aws.iotsitewise.model.PortalState,
    error: Optional[zio.aws.iotsitewise.model.MonitorErrorDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.PortalStatus = {
    import PortalStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.PortalStatus
      .builder()
      .state(state.unwrap)
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.PortalStatus.ReadOnly =
    zio.aws.iotsitewise.model.PortalStatus.wrap(buildAwsValue())
}
object PortalStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.PortalStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.PortalStatus =
      zio.aws.iotsitewise.model
        .PortalStatus(state, error.map(value => value.asEditable))
    def state: zio.aws.iotsitewise.model.PortalState
    def error: Optional[zio.aws.iotsitewise.model.MonitorErrorDetails.ReadOnly]
    def getState: ZIO[Any, Nothing, zio.aws.iotsitewise.model.PortalState] =
      ZIO.succeed(state)
    def getError: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.MonitorErrorDetails.ReadOnly
    ] = AwsError.unwrapOptionField("error", error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.PortalStatus
  ) extends zio.aws.iotsitewise.model.PortalStatus.ReadOnly {
    override val state: zio.aws.iotsitewise.model.PortalState =
      zio.aws.iotsitewise.model.PortalState.wrap(impl.state())
    override val error
        : Optional[zio.aws.iotsitewise.model.MonitorErrorDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.error())
        .map(value => zio.aws.iotsitewise.model.MonitorErrorDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.PortalStatus
  ): zio.aws.iotsitewise.model.PortalStatus.ReadOnly = new Wrapper(impl)
}
