package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutLoggingOptionsRequest(
    loggingOptions: zio.aws.iotsitewise.model.LoggingOptions
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.PutLoggingOptionsRequest = {
    import PutLoggingOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.PutLoggingOptionsRequest
      .builder()
      .loggingOptions(loggingOptions.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.PutLoggingOptionsRequest.ReadOnly =
    zio.aws.iotsitewise.model.PutLoggingOptionsRequest.wrap(buildAwsValue())
}
object PutLoggingOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.PutLoggingOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.PutLoggingOptionsRequest =
      zio.aws.iotsitewise.model
        .PutLoggingOptionsRequest(loggingOptions.asEditable)
    def loggingOptions: zio.aws.iotsitewise.model.LoggingOptions.ReadOnly
    def getLoggingOptions
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.LoggingOptions.ReadOnly] =
      ZIO.succeed(loggingOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.PutLoggingOptionsRequest
  ) extends zio.aws.iotsitewise.model.PutLoggingOptionsRequest.ReadOnly {
    override val loggingOptions
        : zio.aws.iotsitewise.model.LoggingOptions.ReadOnly =
      zio.aws.iotsitewise.model.LoggingOptions.wrap(impl.loggingOptions())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.PutLoggingOptionsRequest
  ): zio.aws.iotsitewise.model.PutLoggingOptionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
