package zio.aws.iotsitewise.model
import scala.jdk.CollectionConverters.*
sealed trait StorageType {
  def unwrap: software.amazon.awssdk.services.iotsitewise.model.StorageType
}
object StorageType {
  def wrap(
      value: software.amazon.awssdk.services.iotsitewise.model.StorageType
  ): zio.aws.iotsitewise.model.StorageType = value match {
    case software.amazon.awssdk.services.iotsitewise.model.StorageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotsitewise.model.StorageType.SITEWISE_DEFAULT_STORAGE =>
      val r = SITEWISE_DEFAULT_STORAGE
      r
    case software.amazon.awssdk.services.iotsitewise.model.StorageType.MULTI_LAYER_STORAGE =>
      val r = MULTI_LAYER_STORAGE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotsitewise.model.StorageType {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.StorageType =
      software.amazon.awssdk.services.iotsitewise.model.StorageType.UNKNOWN_TO_SDK_VERSION
  }
  case object SITEWISE_DEFAULT_STORAGE
      extends zio.aws.iotsitewise.model.StorageType {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.StorageType =
      software.amazon.awssdk.services.iotsitewise.model.StorageType.SITEWISE_DEFAULT_STORAGE
  }
  case object MULTI_LAYER_STORAGE
      extends zio.aws.iotsitewise.model.StorageType {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.StorageType =
      software.amazon.awssdk.services.iotsitewise.model.StorageType.MULTI_LAYER_STORAGE
  }
}
