package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateAssetResponse(
    assetStatus: zio.aws.iotsitewise.model.AssetStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.UpdateAssetResponse = {
    import UpdateAssetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.UpdateAssetResponse
      .builder()
      .assetStatus(assetStatus.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.UpdateAssetResponse.ReadOnly =
    zio.aws.iotsitewise.model.UpdateAssetResponse.wrap(buildAwsValue())
}
object UpdateAssetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.UpdateAssetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.UpdateAssetResponse =
      zio.aws.iotsitewise.model.UpdateAssetResponse(assetStatus.asEditable)
    def assetStatus: zio.aws.iotsitewise.model.AssetStatus.ReadOnly
    def getAssetStatus
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.AssetStatus.ReadOnly] =
      ZIO.succeed(assetStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.UpdateAssetResponse
  ) extends zio.aws.iotsitewise.model.UpdateAssetResponse.ReadOnly {
    override val assetStatus: zio.aws.iotsitewise.model.AssetStatus.ReadOnly =
      zio.aws.iotsitewise.model.AssetStatus.wrap(impl.assetStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.UpdateAssetResponse
  ): zio.aws.iotsitewise.model.UpdateAssetResponse.ReadOnly = new Wrapper(impl)
}
