package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{Name, ID}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateGatewayRequest(gatewayId: ID, gatewayName: Name) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.UpdateGatewayRequest = {
    import UpdateGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.UpdateGatewayRequest
      .builder()
      .gatewayId(ID.unwrap(gatewayId): java.lang.String)
      .gatewayName(Name.unwrap(gatewayName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.UpdateGatewayRequest.ReadOnly =
    zio.aws.iotsitewise.model.UpdateGatewayRequest.wrap(buildAwsValue())
}
object UpdateGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.UpdateGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.UpdateGatewayRequest =
      zio.aws.iotsitewise.model.UpdateGatewayRequest(gatewayId, gatewayName)
    def gatewayId: ID
    def gatewayName: Name
    def getGatewayId: ZIO[Any, Nothing, ID] = ZIO.succeed(gatewayId)
    def getGatewayName: ZIO[Any, Nothing, Name] = ZIO.succeed(gatewayName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.UpdateGatewayRequest
  ) extends zio.aws.iotsitewise.model.UpdateGatewayRequest.ReadOnly {
    override val gatewayId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.gatewayId())
    override val gatewayName: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.gatewayName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.UpdateGatewayRequest
  ): zio.aws.iotsitewise.model.UpdateGatewayRequest.ReadOnly = new Wrapper(impl)
}
