package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{
  Email,
  Description,
  ClientToken,
  Name,
  ARN,
  ID
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdatePortalRequest(
    portalId: ID,
    portalName: Name,
    portalDescription: Optional[Description] = Optional.Absent,
    portalContactEmail: Email,
    portalLogoImage: Optional[zio.aws.iotsitewise.model.Image] =
      Optional.Absent,
    roleArn: ARN,
    clientToken: Optional[ClientToken] = Optional.Absent,
    notificationSenderEmail: Optional[Email] = Optional.Absent,
    alarms: Optional[zio.aws.iotsitewise.model.Alarms] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.UpdatePortalRequest = {
    import UpdatePortalRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.UpdatePortalRequest
      .builder()
      .portalId(ID.unwrap(portalId): java.lang.String)
      .portalName(Name.unwrap(portalName): java.lang.String)
      .optionallyWith(
        portalDescription.map(value =>
          Description.unwrap(value): java.lang.String
        )
      )(_.portalDescription)
      .portalContactEmail(Email.unwrap(portalContactEmail): java.lang.String)
      .optionallyWith(portalLogoImage.map(value => value.buildAwsValue()))(
        _.portalLogoImage
      )
      .roleArn(ARN.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        notificationSenderEmail.map(value =>
          Email.unwrap(value): java.lang.String
        )
      )(_.notificationSenderEmail)
      .optionallyWith(alarms.map(value => value.buildAwsValue()))(_.alarms)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.UpdatePortalRequest.ReadOnly =
    zio.aws.iotsitewise.model.UpdatePortalRequest.wrap(buildAwsValue())
}
object UpdatePortalRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.UpdatePortalRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.UpdatePortalRequest =
      zio.aws.iotsitewise.model.UpdatePortalRequest(
        portalId,
        portalName,
        portalDescription.map(value => value),
        portalContactEmail,
        portalLogoImage.map(value => value.asEditable),
        roleArn,
        clientToken.map(value => value),
        notificationSenderEmail.map(value => value),
        alarms.map(value => value.asEditable)
      )
    def portalId: ID
    def portalName: Name
    def portalDescription: Optional[Description]
    def portalContactEmail: Email
    def portalLogoImage: Optional[zio.aws.iotsitewise.model.Image.ReadOnly]
    def roleArn: ARN
    def clientToken: Optional[ClientToken]
    def notificationSenderEmail: Optional[Email]
    def alarms: Optional[zio.aws.iotsitewise.model.Alarms.ReadOnly]
    def getPortalId: ZIO[Any, Nothing, ID] = ZIO.succeed(portalId)
    def getPortalName: ZIO[Any, Nothing, Name] = ZIO.succeed(portalName)
    def getPortalDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("portalDescription", portalDescription)
    def getPortalContactEmail: ZIO[Any, Nothing, Email] =
      ZIO.succeed(portalContactEmail)
    def getPortalLogoImage
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.Image.ReadOnly] =
      AwsError.unwrapOptionField("portalLogoImage", portalLogoImage)
    def getRoleArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(roleArn)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getNotificationSenderEmail: ZIO[Any, AwsError, Email] = AwsError
      .unwrapOptionField("notificationSenderEmail", notificationSenderEmail)
    def getAlarms
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.Alarms.ReadOnly] =
      AwsError.unwrapOptionField("alarms", alarms)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.UpdatePortalRequest
  ) extends zio.aws.iotsitewise.model.UpdatePortalRequest.ReadOnly {
    override val portalId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.portalId())
    override val portalName: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.portalName())
    override val portalDescription: Optional[Description] =
      zio.aws.core.internal
        .optionalFromNullable(impl.portalDescription())
        .map(value => zio.aws.iotsitewise.model.primitives.Description(value))
    override val portalContactEmail: Email =
      zio.aws.iotsitewise.model.primitives.Email(impl.portalContactEmail())
    override val portalLogoImage
        : Optional[zio.aws.iotsitewise.model.Image.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.portalLogoImage())
        .map(value => zio.aws.iotsitewise.model.Image.wrap(value))
    override val roleArn: ARN =
      zio.aws.iotsitewise.model.primitives.ARN(impl.roleArn())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.iotsitewise.model.primitives.ClientToken(value))
    override val notificationSenderEmail: Optional[Email] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationSenderEmail())
        .map(value => zio.aws.iotsitewise.model.primitives.Email(value))
    override val alarms: Optional[zio.aws.iotsitewise.model.Alarms.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alarms())
        .map(value => zio.aws.iotsitewise.model.Alarms.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.UpdatePortalRequest
  ): zio.aws.iotsitewise.model.UpdatePortalRequest.ReadOnly = new Wrapper(impl)
}
