package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.IdentityId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UserIdentity(id: IdentityId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.UserIdentity = {
    import UserIdentity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.UserIdentity
      .builder()
      .id(IdentityId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.UserIdentity.ReadOnly =
    zio.aws.iotsitewise.model.UserIdentity.wrap(buildAwsValue())
}
object UserIdentity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.UserIdentity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.UserIdentity =
      zio.aws.iotsitewise.model.UserIdentity(id)
    def id: IdentityId
    def getId: ZIO[Any, Nothing, IdentityId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.UserIdentity
  ) extends zio.aws.iotsitewise.model.UserIdentity.ReadOnly {
    override val id: IdentityId =
      zio.aws.iotsitewise.model.primitives.IdentityId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.UserIdentity
  ): zio.aws.iotsitewise.model.UserIdentity.ReadOnly = new Wrapper(impl)
}
