package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.AggregatedDoubleValue
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Aggregates(
    average: Optional[AggregatedDoubleValue] = Optional.Absent,
    count: Optional[AggregatedDoubleValue] = Optional.Absent,
    maximum: Optional[AggregatedDoubleValue] = Optional.Absent,
    minimum: Optional[AggregatedDoubleValue] = Optional.Absent,
    sum: Optional[AggregatedDoubleValue] = Optional.Absent,
    standardDeviation: Optional[AggregatedDoubleValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.Aggregates = {
    import Aggregates.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.Aggregates
      .builder()
      .optionallyWith(
        average.map(value =>
          AggregatedDoubleValue.unwrap(value): java.lang.Double
        )
      )(_.average)
      .optionallyWith(
        count.map(value =>
          AggregatedDoubleValue.unwrap(value): java.lang.Double
        )
      )(_.count)
      .optionallyWith(
        maximum.map(value =>
          AggregatedDoubleValue.unwrap(value): java.lang.Double
        )
      )(_.maximum)
      .optionallyWith(
        minimum.map(value =>
          AggregatedDoubleValue.unwrap(value): java.lang.Double
        )
      )(_.minimum)
      .optionallyWith(
        sum.map(value => AggregatedDoubleValue.unwrap(value): java.lang.Double)
      )(_.sum)
      .optionallyWith(
        standardDeviation.map(value =>
          AggregatedDoubleValue.unwrap(value): java.lang.Double
        )
      )(_.standardDeviation)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.Aggregates.ReadOnly =
    zio.aws.iotsitewise.model.Aggregates.wrap(buildAwsValue())
}
object Aggregates {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.Aggregates
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.Aggregates =
      zio.aws.iotsitewise.model.Aggregates(
        average.map(value => value),
        count.map(value => value),
        maximum.map(value => value),
        minimum.map(value => value),
        sum.map(value => value),
        standardDeviation.map(value => value)
      )
    def average: Optional[AggregatedDoubleValue]
    def count: Optional[AggregatedDoubleValue]
    def maximum: Optional[AggregatedDoubleValue]
    def minimum: Optional[AggregatedDoubleValue]
    def sum: Optional[AggregatedDoubleValue]
    def standardDeviation: Optional[AggregatedDoubleValue]
    def getAverage: ZIO[Any, AwsError, AggregatedDoubleValue] =
      AwsError.unwrapOptionField("average", average)
    def getCount: ZIO[Any, AwsError, AggregatedDoubleValue] =
      AwsError.unwrapOptionField("count", count)
    def getMaximum: ZIO[Any, AwsError, AggregatedDoubleValue] =
      AwsError.unwrapOptionField("maximum", maximum)
    def getMinimum: ZIO[Any, AwsError, AggregatedDoubleValue] =
      AwsError.unwrapOptionField("minimum", minimum)
    def getSum: ZIO[Any, AwsError, AggregatedDoubleValue] =
      AwsError.unwrapOptionField("sum", sum)
    def getStandardDeviation: ZIO[Any, AwsError, AggregatedDoubleValue] =
      AwsError.unwrapOptionField("standardDeviation", standardDeviation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.Aggregates
  ) extends zio.aws.iotsitewise.model.Aggregates.ReadOnly {
    override val average: Optional[AggregatedDoubleValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.average())
        .map(value =>
          zio.aws.iotsitewise.model.primitives.AggregatedDoubleValue(value)
        )
    override val count: Optional[AggregatedDoubleValue] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value =>
        zio.aws.iotsitewise.model.primitives.AggregatedDoubleValue(value)
      )
    override val maximum: Optional[AggregatedDoubleValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximum())
        .map(value =>
          zio.aws.iotsitewise.model.primitives.AggregatedDoubleValue(value)
        )
    override val minimum: Optional[AggregatedDoubleValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minimum())
        .map(value =>
          zio.aws.iotsitewise.model.primitives.AggregatedDoubleValue(value)
        )
    override val sum: Optional[AggregatedDoubleValue] = zio.aws.core.internal
      .optionalFromNullable(impl.sum())
      .map(value =>
        zio.aws.iotsitewise.model.primitives.AggregatedDoubleValue(value)
      )
    override val standardDeviation: Optional[AggregatedDoubleValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.standardDeviation())
        .map(value =>
          zio.aws.iotsitewise.model.primitives.AggregatedDoubleValue(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.Aggregates
  ): zio.aws.iotsitewise.model.Aggregates.ReadOnly = new Wrapper(impl)
}
