package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{Description, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AssetModelCompositeModel(
    name: Name,
    description: Optional[Description] = Optional.Absent,
    `type`: Name,
    properties: Optional[
      Iterable[zio.aws.iotsitewise.model.AssetModelProperty]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModel = {
    import AssetModelCompositeModel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModel
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .`type`(Name.unwrap(`type`): java.lang.String)
      .optionallyWith(
        properties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.properties)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.AssetModelCompositeModel.ReadOnly =
    zio.aws.iotsitewise.model.AssetModelCompositeModel.wrap(buildAwsValue())
}
object AssetModelCompositeModel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.AssetModelCompositeModel =
      zio.aws.iotsitewise.model.AssetModelCompositeModel(
        name,
        description.map(value => value),
        `type`,
        properties.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Name
    def description: Optional[Description]
    def `type`: Name
    def properties
        : Optional[List[zio.aws.iotsitewise.model.AssetModelProperty.ReadOnly]]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getType: ZIO[Any, Nothing, Name] = ZIO.succeed(`type`)
    def getProperties: ZIO[Any, AwsError, List[
      zio.aws.iotsitewise.model.AssetModelProperty.ReadOnly
    ]] = AwsError.unwrapOptionField("properties", properties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModel
  ) extends zio.aws.iotsitewise.model.AssetModelCompositeModel.ReadOnly {
    override val name: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotsitewise.model.primitives.Description(value))
    override val `type`: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.`type`())
    override val properties: Optional[
      List[zio.aws.iotsitewise.model.AssetModelProperty.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.properties())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotsitewise.model.AssetModelProperty.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModel
  ): zio.aws.iotsitewise.model.AssetModelCompositeModel.ReadOnly = new Wrapper(
    impl
  )
}
