package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{PropertyUnit, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AssetModelPropertyDefinition(
    name: Name,
    dataType: zio.aws.iotsitewise.model.PropertyDataType,
    dataTypeSpec: Optional[Name] = Optional.Absent,
    unit: Optional[PropertyUnit] = Optional.Absent,
    `type`: zio.aws.iotsitewise.model.PropertyType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertyDefinition = {
    import AssetModelPropertyDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertyDefinition
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .dataType(dataType.unwrap)
      .optionallyWith(
        dataTypeSpec.map(value => Name.unwrap(value): java.lang.String)
      )(_.dataTypeSpec)
      .optionallyWith(
        unit.map(value => PropertyUnit.unwrap(value): java.lang.String)
      )(_.unit)
      .`type`(`type`.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.AssetModelPropertyDefinition.ReadOnly =
    zio.aws.iotsitewise.model.AssetModelPropertyDefinition.wrap(buildAwsValue())
}
object AssetModelPropertyDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertyDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.AssetModelPropertyDefinition =
      zio.aws.iotsitewise.model.AssetModelPropertyDefinition(
        name,
        dataType,
        dataTypeSpec.map(value => value),
        unit.map(value => value),
        `type`.asEditable
      )
    def name: Name
    def dataType: zio.aws.iotsitewise.model.PropertyDataType
    def dataTypeSpec: Optional[Name]
    def unit: Optional[PropertyUnit]
    def `type`: zio.aws.iotsitewise.model.PropertyType.ReadOnly
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDataType
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.PropertyDataType] =
      ZIO.succeed(dataType)
    def getDataTypeSpec: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("dataTypeSpec", dataTypeSpec)
    def getUnit: ZIO[Any, AwsError, PropertyUnit] =
      AwsError.unwrapOptionField("unit", unit)
    def getType
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.PropertyType.ReadOnly] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertyDefinition
  ) extends zio.aws.iotsitewise.model.AssetModelPropertyDefinition.ReadOnly {
    override val name: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.name())
    override val dataType: zio.aws.iotsitewise.model.PropertyDataType =
      zio.aws.iotsitewise.model.PropertyDataType.wrap(impl.dataType())
    override val dataTypeSpec: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.dataTypeSpec())
      .map(value => zio.aws.iotsitewise.model.primitives.Name(value))
    override val unit: Optional[PropertyUnit] = zio.aws.core.internal
      .optionalFromNullable(impl.unit())
      .map(value => zio.aws.iotsitewise.model.primitives.PropertyUnit(value))
    override val `type`: zio.aws.iotsitewise.model.PropertyType.ReadOnly =
      zio.aws.iotsitewise.model.PropertyType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertyDefinition
  ): zio.aws.iotsitewise.model.AssetModelPropertyDefinition.ReadOnly =
    new Wrapper(impl)
}
