package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{
  Timestamp,
  Description,
  Name,
  ARN,
  ID
}
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class AssetModelSummary(
    id: ID,
    arn: ARN,
    name: Name,
    description: Description,
    creationDate: Timestamp,
    lastUpdateDate: Timestamp,
    status: zio.aws.iotsitewise.model.AssetModelStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.AssetModelSummary = {
    import AssetModelSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.AssetModelSummary
      .builder()
      .id(ID.unwrap(id): java.lang.String)
      .arn(ARN.unwrap(arn): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .description(Description.unwrap(description): java.lang.String)
      .creationDate(Timestamp.unwrap(creationDate): Instant)
      .lastUpdateDate(Timestamp.unwrap(lastUpdateDate): Instant)
      .status(status.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.AssetModelSummary.ReadOnly =
    zio.aws.iotsitewise.model.AssetModelSummary.wrap(buildAwsValue())
}
object AssetModelSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.AssetModelSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.AssetModelSummary =
      zio.aws.iotsitewise.model.AssetModelSummary(
        id,
        arn,
        name,
        description,
        creationDate,
        lastUpdateDate,
        status.asEditable
      )
    def id: ID
    def arn: ARN
    def name: Name
    def description: Description
    def creationDate: Timestamp
    def lastUpdateDate: Timestamp
    def status: zio.aws.iotsitewise.model.AssetModelStatus.ReadOnly
    def getId: ZIO[Any, Nothing, ID] = ZIO.succeed(id)
    def getArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(arn)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDescription: ZIO[Any, Nothing, Description] =
      ZIO.succeed(description)
    def getCreationDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDate)
    def getLastUpdateDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastUpdateDate)
    def getStatus: ZIO[
      Any,
      Nothing,
      zio.aws.iotsitewise.model.AssetModelStatus.ReadOnly
    ] = ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetModelSummary
  ) extends zio.aws.iotsitewise.model.AssetModelSummary.ReadOnly {
    override val id: ID = zio.aws.iotsitewise.model.primitives.ID(impl.id())
    override val arn: ARN = zio.aws.iotsitewise.model.primitives.ARN(impl.arn())
    override val name: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.name())
    override val description: Description =
      zio.aws.iotsitewise.model.primitives.Description(impl.description())
    override val creationDate: Timestamp =
      zio.aws.iotsitewise.model.primitives.Timestamp(impl.creationDate())
    override val lastUpdateDate: Timestamp =
      zio.aws.iotsitewise.model.primitives.Timestamp(impl.lastUpdateDate())
    override val status: zio.aws.iotsitewise.model.AssetModelStatus.ReadOnly =
      zio.aws.iotsitewise.model.AssetModelStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetModelSummary
  ): zio.aws.iotsitewise.model.AssetModelSummary.ReadOnly = new Wrapper(impl)
}
