package zio.aws.iotsitewise.model
import scala.jdk.CollectionConverters.*
sealed trait AuthMode {
  def unwrap: software.amazon.awssdk.services.iotsitewise.model.AuthMode
}
object AuthMode {
  def wrap(
      value: software.amazon.awssdk.services.iotsitewise.model.AuthMode
  ): zio.aws.iotsitewise.model.AuthMode = value match {
    case software.amazon.awssdk.services.iotsitewise.model.AuthMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotsitewise.model.AuthMode.IAM =>
      val r = IAM
      r
    case software.amazon.awssdk.services.iotsitewise.model.AuthMode.SSO =>
      val r = SSO
      r
  }
  case object unknownToSdkVersion extends zio.aws.iotsitewise.model.AuthMode {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.AuthMode =
      software.amazon.awssdk.services.iotsitewise.model.AuthMode.UNKNOWN_TO_SDK_VERSION
  }
  case object IAM extends zio.aws.iotsitewise.model.AuthMode {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.AuthMode =
      software.amazon.awssdk.services.iotsitewise.model.AuthMode.IAM
  }
  case object SSO extends zio.aws.iotsitewise.model.AuthMode {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.AuthMode =
      software.amazon.awssdk.services.iotsitewise.model.AuthMode.SSO
  }
}
