package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchAssociateProjectAssetsResponse(
    errors: Optional[Iterable[zio.aws.iotsitewise.model.AssetErrorDetails]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.BatchAssociateProjectAssetsResponse = {
    import BatchAssociateProjectAssetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.BatchAssociateProjectAssetsResponse
      .builder()
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.BatchAssociateProjectAssetsResponse.ReadOnly =
    zio.aws.iotsitewise.model.BatchAssociateProjectAssetsResponse
      .wrap(buildAwsValue())
}
object BatchAssociateProjectAssetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.BatchAssociateProjectAssetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.BatchAssociateProjectAssetsResponse =
      zio.aws.iotsitewise.model.BatchAssociateProjectAssetsResponse(
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def errors
        : Optional[List[zio.aws.iotsitewise.model.AssetErrorDetails.ReadOnly]]
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.iotsitewise.model.AssetErrorDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchAssociateProjectAssetsResponse
  ) extends zio.aws.iotsitewise.model.BatchAssociateProjectAssetsResponse.ReadOnly {
    override val errors
        : Optional[List[zio.aws.iotsitewise.model.AssetErrorDetails.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotsitewise.model.AssetErrorDetails.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchAssociateProjectAssetsResponse
  ): zio.aws.iotsitewise.model.BatchAssociateProjectAssetsResponse.ReadOnly =
    new Wrapper(impl)
}
