package zio.aws.iotsitewise.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotsitewise.model.primitives.{
  AssetPropertyAlias,
  Timestamp,
  EntryId,
  Resolution,
  ID
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class BatchGetAssetPropertyAggregatesEntry(
    entryId: EntryId,
    assetId: Optional[ID] = Optional.Absent,
    propertyId: Optional[ID] = Optional.Absent,
    propertyAlias: Optional[AssetPropertyAlias] = Optional.Absent,
    aggregateTypes: Iterable[zio.aws.iotsitewise.model.AggregateType],
    resolution: Resolution,
    startDate: Timestamp,
    endDate: Timestamp,
    qualities: Optional[Iterable[zio.aws.iotsitewise.model.Quality]] =
      Optional.Absent,
    timeOrdering: Optional[zio.aws.iotsitewise.model.TimeOrdering] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesEntry = {
    import BatchGetAssetPropertyAggregatesEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesEntry
      .builder()
      .entryId(EntryId.unwrap(entryId): java.lang.String)
      .optionallyWith(assetId.map(value => ID.unwrap(value): java.lang.String))(
        _.assetId
      )
      .optionallyWith(
        propertyId.map(value => ID.unwrap(value): java.lang.String)
      )(_.propertyId)
      .optionallyWith(
        propertyAlias.map(value =>
          AssetPropertyAlias.unwrap(value): java.lang.String
        )
      )(_.propertyAlias)
      .aggregateTypesWithStrings(aggregateTypes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .resolution(Resolution.unwrap(resolution): java.lang.String)
      .startDate(Timestamp.unwrap(startDate): Instant)
      .endDate(Timestamp.unwrap(endDate): Instant)
      .optionallyWith(
        qualities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.qualitiesWithStrings)
      .optionallyWith(timeOrdering.map(value => value.unwrap))(_.timeOrdering)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesEntry.ReadOnly =
    zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesEntry
      .wrap(buildAwsValue())
}
object BatchGetAssetPropertyAggregatesEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesEntry =
      zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesEntry(
        entryId,
        assetId.map(value => value),
        propertyId.map(value => value),
        propertyAlias.map(value => value),
        aggregateTypes,
        resolution,
        startDate,
        endDate,
        qualities.map(value => value),
        timeOrdering.map(value => value)
      )
    def entryId: EntryId
    def assetId: Optional[ID]
    def propertyId: Optional[ID]
    def propertyAlias: Optional[AssetPropertyAlias]
    def aggregateTypes: List[zio.aws.iotsitewise.model.AggregateType]
    def resolution: Resolution
    def startDate: Timestamp
    def endDate: Timestamp
    def qualities: Optional[List[zio.aws.iotsitewise.model.Quality]]
    def timeOrdering: Optional[zio.aws.iotsitewise.model.TimeOrdering]
    def getEntryId: ZIO[Any, Nothing, EntryId] = ZIO.succeed(entryId)
    def getAssetId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("assetId", assetId)
    def getPropertyId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("propertyId", propertyId)
    def getPropertyAlias: ZIO[Any, AwsError, AssetPropertyAlias] =
      AwsError.unwrapOptionField("propertyAlias", propertyAlias)
    def getAggregateTypes
        : ZIO[Any, Nothing, List[zio.aws.iotsitewise.model.AggregateType]] =
      ZIO.succeed(aggregateTypes)
    def getResolution: ZIO[Any, Nothing, Resolution] = ZIO.succeed(resolution)
    def getStartDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startDate)
    def getEndDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endDate)
    def getQualities
        : ZIO[Any, AwsError, List[zio.aws.iotsitewise.model.Quality]] =
      AwsError.unwrapOptionField("qualities", qualities)
    def getTimeOrdering
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.TimeOrdering] =
      AwsError.unwrapOptionField("timeOrdering", timeOrdering)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesEntry
  ) extends zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesEntry.ReadOnly {
    override val entryId: EntryId =
      zio.aws.iotsitewise.model.primitives.EntryId(impl.entryId())
    override val assetId: Optional[ID] = zio.aws.core.internal
      .optionalFromNullable(impl.assetId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val propertyId: Optional[ID] = zio.aws.core.internal
      .optionalFromNullable(impl.propertyId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val propertyAlias: Optional[AssetPropertyAlias] =
      zio.aws.core.internal
        .optionalFromNullable(impl.propertyAlias())
        .map(value =>
          zio.aws.iotsitewise.model.primitives.AssetPropertyAlias(value)
        )
    override val aggregateTypes: List[zio.aws.iotsitewise.model.AggregateType] =
      impl
        .aggregateTypes()
        .asScala
        .map { item =>
          zio.aws.iotsitewise.model.AggregateType.wrap(item)
        }
        .toList
    override val resolution: Resolution =
      zio.aws.iotsitewise.model.primitives.Resolution(impl.resolution())
    override val startDate: Timestamp =
      zio.aws.iotsitewise.model.primitives.Timestamp(impl.startDate())
    override val endDate: Timestamp =
      zio.aws.iotsitewise.model.primitives.Timestamp(impl.endDate())
    override val qualities: Optional[List[zio.aws.iotsitewise.model.Quality]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.qualities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotsitewise.model.Quality.wrap(item)
          }.toList
        )
    override val timeOrdering
        : Optional[zio.aws.iotsitewise.model.TimeOrdering] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeOrdering())
        .map(value => zio.aws.iotsitewise.model.TimeOrdering.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesEntry
  ): zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesEntry.ReadOnly =
    new Wrapper(impl)
}
