package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{EntryId, ErrorMessage}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchGetAssetPropertyAggregatesErrorEntry(
    errorCode: zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorCode,
    errorMessage: ErrorMessage,
    entryId: EntryId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorEntry = {
    import BatchGetAssetPropertyAggregatesErrorEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorEntry
      .builder()
      .errorCode(errorCode.unwrap)
      .errorMessage(ErrorMessage.unwrap(errorMessage): java.lang.String)
      .entryId(EntryId.unwrap(entryId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorEntry.ReadOnly =
    zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorEntry
      .wrap(buildAwsValue())
}
object BatchGetAssetPropertyAggregatesErrorEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorEntry =
      zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorEntry(
        errorCode,
        errorMessage,
        entryId
      )
    def errorCode
        : zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorCode
    def errorMessage: ErrorMessage
    def entryId: EntryId
    def getErrorCode: ZIO[
      Any,
      Nothing,
      zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorCode
    ] = ZIO.succeed(errorCode)
    def getErrorMessage: ZIO[Any, Nothing, ErrorMessage] =
      ZIO.succeed(errorMessage)
    def getEntryId: ZIO[Any, Nothing, EntryId] = ZIO.succeed(entryId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorEntry
  ) extends zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorEntry.ReadOnly {
    override val errorCode
        : zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorCode =
      zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorCode
        .wrap(impl.errorCode())
    override val errorMessage: ErrorMessage =
      zio.aws.iotsitewise.model.primitives.ErrorMessage(impl.errorMessage())
    override val entryId: EntryId =
      zio.aws.iotsitewise.model.primitives.EntryId(impl.entryId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorEntry
  ): zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorEntry.ReadOnly =
    new Wrapper(impl)
}
