package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.Timestamp
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class BatchGetAssetPropertyAggregatesErrorInfo(
    errorCode: zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorCode,
    errorTimestamp: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorInfo = {
    import BatchGetAssetPropertyAggregatesErrorInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorInfo
      .builder()
      .errorCode(errorCode.unwrap)
      .errorTimestamp(Timestamp.unwrap(errorTimestamp): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorInfo.ReadOnly =
    zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorInfo
      .wrap(buildAwsValue())
}
object BatchGetAssetPropertyAggregatesErrorInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorInfo =
      zio.aws.iotsitewise.model
        .BatchGetAssetPropertyAggregatesErrorInfo(errorCode, errorTimestamp)
    def errorCode
        : zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorCode
    def errorTimestamp: Timestamp
    def getErrorCode: ZIO[
      Any,
      Nothing,
      zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorCode
    ] = ZIO.succeed(errorCode)
    def getErrorTimestamp: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(errorTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorInfo
  ) extends zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorInfo.ReadOnly {
    override val errorCode
        : zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorCode =
      zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorCode
        .wrap(impl.errorCode())
    override val errorTimestamp: Timestamp =
      zio.aws.iotsitewise.model.primitives.Timestamp(impl.errorTimestamp())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorInfo
  ): zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorInfo.ReadOnly =
    new Wrapper(impl)
}
