package zio.aws.iotsitewise.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotsitewise.model.primitives.{
  BatchGetAssetPropertyAggregatesMaxResults,
  NextToken
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class BatchGetAssetPropertyAggregatesRequest(
    entries: Iterable[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesEntry
    ],
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[BatchGetAssetPropertyAggregatesMaxResults] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesRequest = {
    import BatchGetAssetPropertyAggregatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesRequest
      .builder()
      .entries(entries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          BatchGetAssetPropertyAggregatesMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesRequest.ReadOnly =
    zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesRequest
      .wrap(buildAwsValue())
}
object BatchGetAssetPropertyAggregatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesRequest =
      zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesRequest(
        entries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def entries: List[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesEntry.ReadOnly
    ]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[BatchGetAssetPropertyAggregatesMaxResults]
    def getEntries: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesEntry.ReadOnly
    ]] = ZIO.succeed(entries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, BatchGetAssetPropertyAggregatesMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesRequest
  ) extends zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesRequest.ReadOnly {
    override val entries: List[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesEntry.ReadOnly
    ] = impl
      .entries()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesEntry
          .wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
    override val maxResults
        : Optional[BatchGetAssetPropertyAggregatesMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.iotsitewise.model.primitives
            .BatchGetAssetPropertyAggregatesMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesRequest
  ): zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesRequest.ReadOnly =
    new Wrapper(impl)
}
