package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchGetAssetPropertyAggregatesResponse(
    errorEntries: Iterable[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorEntry
    ],
    successEntries: Iterable[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesSuccessEntry
    ],
    skippedEntries: Iterable[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesSkippedEntry
    ],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesResponse = {
    import BatchGetAssetPropertyAggregatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesResponse
      .builder()
      .errorEntries(errorEntries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .successEntries(successEntries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .skippedEntries(skippedEntries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesResponse.ReadOnly =
    zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesResponse
      .wrap(buildAwsValue())
}
object BatchGetAssetPropertyAggregatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesResponse =
      zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesResponse(
        errorEntries.map { item =>
          item.asEditable
        },
        successEntries.map { item =>
          item.asEditable
        },
        skippedEntries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def errorEntries: List[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorEntry.ReadOnly
    ]
    def successEntries: List[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesSuccessEntry.ReadOnly
    ]
    def skippedEntries: List[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesSkippedEntry.ReadOnly
    ]
    def nextToken: Optional[NextToken]
    def getErrorEntries: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorEntry.ReadOnly
    ]] = ZIO.succeed(errorEntries)
    def getSuccessEntries: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesSuccessEntry.ReadOnly
    ]] = ZIO.succeed(successEntries)
    def getSkippedEntries: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesSkippedEntry.ReadOnly
    ]] = ZIO.succeed(skippedEntries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesResponse
  ) extends zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesResponse.ReadOnly {
    override val errorEntries: List[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorEntry.ReadOnly
    ] = impl
      .errorEntries()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorEntry
          .wrap(item)
      }
      .toList
    override val successEntries: List[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesSuccessEntry.ReadOnly
    ] = impl
      .successEntries()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesSuccessEntry
          .wrap(item)
      }
      .toList
    override val skippedEntries: List[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesSkippedEntry.ReadOnly
    ] = impl
      .skippedEntries()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesSkippedEntry
          .wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesResponse
  ): zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesResponse.ReadOnly =
    new Wrapper(impl)
}
