package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.EntryId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchGetAssetPropertyAggregatesSkippedEntry(
    entryId: EntryId,
    completionStatus: zio.aws.iotsitewise.model.BatchEntryCompletionStatus,
    errorInfo: Optional[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorInfo
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesSkippedEntry = {
    import BatchGetAssetPropertyAggregatesSkippedEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesSkippedEntry
      .builder()
      .entryId(EntryId.unwrap(entryId): java.lang.String)
      .completionStatus(completionStatus.unwrap)
      .optionallyWith(errorInfo.map(value => value.buildAwsValue()))(
        _.errorInfo
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesSkippedEntry.ReadOnly =
    zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesSkippedEntry
      .wrap(buildAwsValue())
}
object BatchGetAssetPropertyAggregatesSkippedEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesSkippedEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesSkippedEntry =
      zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesSkippedEntry(
        entryId,
        completionStatus,
        errorInfo.map(value => value.asEditable)
      )
    def entryId: EntryId
    def completionStatus: zio.aws.iotsitewise.model.BatchEntryCompletionStatus
    def errorInfo: Optional[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorInfo.ReadOnly
    ]
    def getEntryId: ZIO[Any, Nothing, EntryId] = ZIO.succeed(entryId)
    def getCompletionStatus: ZIO[
      Any,
      Nothing,
      zio.aws.iotsitewise.model.BatchEntryCompletionStatus
    ] = ZIO.succeed(completionStatus)
    def getErrorInfo: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorInfo.ReadOnly
    ] = AwsError.unwrapOptionField("errorInfo", errorInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesSkippedEntry
  ) extends zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesSkippedEntry.ReadOnly {
    override val entryId: EntryId =
      zio.aws.iotsitewise.model.primitives.EntryId(impl.entryId())
    override val completionStatus
        : zio.aws.iotsitewise.model.BatchEntryCompletionStatus =
      zio.aws.iotsitewise.model.BatchEntryCompletionStatus
        .wrap(impl.completionStatus())
    override val errorInfo: Optional[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorInfo.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.errorInfo())
      .map(value =>
        zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorInfo
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesSkippedEntry
  ): zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesSkippedEntry.ReadOnly =
    new Wrapper(impl)
}
