package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.Timestamp
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class BatchGetAssetPropertyValueErrorInfo(
    errorCode: zio.aws.iotsitewise.model.BatchGetAssetPropertyValueErrorCode,
    errorTimestamp: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueErrorInfo = {
    import BatchGetAssetPropertyValueErrorInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueErrorInfo
      .builder()
      .errorCode(errorCode.unwrap)
      .errorTimestamp(Timestamp.unwrap(errorTimestamp): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.BatchGetAssetPropertyValueErrorInfo.ReadOnly =
    zio.aws.iotsitewise.model.BatchGetAssetPropertyValueErrorInfo
      .wrap(buildAwsValue())
}
object BatchGetAssetPropertyValueErrorInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueErrorInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.BatchGetAssetPropertyValueErrorInfo =
      zio.aws.iotsitewise.model
        .BatchGetAssetPropertyValueErrorInfo(errorCode, errorTimestamp)
    def errorCode: zio.aws.iotsitewise.model.BatchGetAssetPropertyValueErrorCode
    def errorTimestamp: Timestamp
    def getErrorCode: ZIO[
      Any,
      Nothing,
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueErrorCode
    ] = ZIO.succeed(errorCode)
    def getErrorTimestamp: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(errorTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueErrorInfo
  ) extends zio.aws.iotsitewise.model.BatchGetAssetPropertyValueErrorInfo.ReadOnly {
    override val errorCode
        : zio.aws.iotsitewise.model.BatchGetAssetPropertyValueErrorCode =
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueErrorCode
        .wrap(impl.errorCode())
    override val errorTimestamp: Timestamp =
      zio.aws.iotsitewise.model.primitives.Timestamp(impl.errorTimestamp())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueErrorInfo
  ): zio.aws.iotsitewise.model.BatchGetAssetPropertyValueErrorInfo.ReadOnly =
    new Wrapper(impl)
}
