package zio.aws.iotsitewise.model
import scala.jdk.CollectionConverters.*
sealed trait BatchGetAssetPropertyValueHistoryErrorCode {
  def unwrap: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorCode
}
object BatchGetAssetPropertyValueHistoryErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorCode
  ): zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorCode =
    value match {
      case software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorCode.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorCode.RESOURCE_NOT_FOUND_EXCEPTION =>
        val r = ResourceNotFoundException
        r
      case software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorCode.INVALID_REQUEST_EXCEPTION =>
        val r = InvalidRequestException
        r
      case software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorCode.ACCESS_DENIED_EXCEPTION =>
        val r = AccessDeniedException
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorCode =
      software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object ResourceNotFoundException
      extends zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorCode =
      software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorCode.RESOURCE_NOT_FOUND_EXCEPTION
  }
  case object InvalidRequestException
      extends zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorCode =
      software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorCode.INVALID_REQUEST_EXCEPTION
  }
  case object AccessDeniedException
      extends zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorCode =
      software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorCode.ACCESS_DENIED_EXCEPTION
  }
}
