package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.Timestamp
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class BatchGetAssetPropertyValueHistoryErrorInfo(
    errorCode: zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorCode,
    errorTimestamp: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorInfo = {
    import BatchGetAssetPropertyValueHistoryErrorInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorInfo
      .builder()
      .errorCode(errorCode.unwrap)
      .errorTimestamp(Timestamp.unwrap(errorTimestamp): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorInfo.ReadOnly =
    zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorInfo
      .wrap(buildAwsValue())
}
object BatchGetAssetPropertyValueHistoryErrorInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorInfo =
      zio.aws.iotsitewise.model
        .BatchGetAssetPropertyValueHistoryErrorInfo(errorCode, errorTimestamp)
    def errorCode
        : zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorCode
    def errorTimestamp: Timestamp
    def getErrorCode: ZIO[
      Any,
      Nothing,
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorCode
    ] = ZIO.succeed(errorCode)
    def getErrorTimestamp: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(errorTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorInfo
  ) extends zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorInfo.ReadOnly {
    override val errorCode
        : zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorCode =
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorCode
        .wrap(impl.errorCode())
    override val errorTimestamp: Timestamp =
      zio.aws.iotsitewise.model.primitives.Timestamp(impl.errorTimestamp())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorInfo
  ): zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorInfo.ReadOnly =
    new Wrapper(impl)
}
