package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.EntryId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchGetAssetPropertyValueHistorySuccessEntry(
    entryId: EntryId,
    assetPropertyValueHistory: Iterable[
      zio.aws.iotsitewise.model.AssetPropertyValue
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistorySuccessEntry = {
    import BatchGetAssetPropertyValueHistorySuccessEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistorySuccessEntry
      .builder()
      .entryId(EntryId.unwrap(entryId): java.lang.String)
      .assetPropertyValueHistory(assetPropertyValueHistory.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistorySuccessEntry.ReadOnly =
    zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistorySuccessEntry
      .wrap(buildAwsValue())
}
object BatchGetAssetPropertyValueHistorySuccessEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistorySuccessEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistorySuccessEntry =
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistorySuccessEntry(
        entryId,
        assetPropertyValueHistory.map { item =>
          item.asEditable
        }
      )
    def entryId: EntryId
    def assetPropertyValueHistory
        : List[zio.aws.iotsitewise.model.AssetPropertyValue.ReadOnly]
    def getEntryId: ZIO[Any, Nothing, EntryId] = ZIO.succeed(entryId)
    def getAssetPropertyValueHistory: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.AssetPropertyValue.ReadOnly
    ]] = ZIO.succeed(assetPropertyValueHistory)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistorySuccessEntry
  ) extends zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistorySuccessEntry.ReadOnly {
    override val entryId: EntryId =
      zio.aws.iotsitewise.model.primitives.EntryId(impl.entryId())
    override val assetPropertyValueHistory
        : List[zio.aws.iotsitewise.model.AssetPropertyValue.ReadOnly] = impl
      .assetPropertyValueHistory()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.AssetPropertyValue.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistorySuccessEntry
  ): zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistorySuccessEntry.ReadOnly =
    new Wrapper(impl)
}
