package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.EntryId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchGetAssetPropertyValueSuccessEntry(
    entryId: EntryId,
    assetPropertyValue: Optional[zio.aws.iotsitewise.model.AssetPropertyValue] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueSuccessEntry = {
    import BatchGetAssetPropertyValueSuccessEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueSuccessEntry
      .builder()
      .entryId(EntryId.unwrap(entryId): java.lang.String)
      .optionallyWith(assetPropertyValue.map(value => value.buildAwsValue()))(
        _.assetPropertyValue
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.BatchGetAssetPropertyValueSuccessEntry.ReadOnly =
    zio.aws.iotsitewise.model.BatchGetAssetPropertyValueSuccessEntry
      .wrap(buildAwsValue())
}
object BatchGetAssetPropertyValueSuccessEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueSuccessEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.BatchGetAssetPropertyValueSuccessEntry =
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueSuccessEntry(
        entryId,
        assetPropertyValue.map(value => value.asEditable)
      )
    def entryId: EntryId
    def assetPropertyValue
        : Optional[zio.aws.iotsitewise.model.AssetPropertyValue.ReadOnly]
    def getEntryId: ZIO[Any, Nothing, EntryId] = ZIO.succeed(entryId)
    def getAssetPropertyValue: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.AssetPropertyValue.ReadOnly
    ] = AwsError.unwrapOptionField("assetPropertyValue", assetPropertyValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueSuccessEntry
  ) extends zio.aws.iotsitewise.model.BatchGetAssetPropertyValueSuccessEntry.ReadOnly {
    override val entryId: EntryId =
      zio.aws.iotsitewise.model.primitives.EntryId(impl.entryId())
    override val assetPropertyValue
        : Optional[zio.aws.iotsitewise.model.AssetPropertyValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assetPropertyValue())
        .map(value => zio.aws.iotsitewise.model.AssetPropertyValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueSuccessEntry
  ): zio.aws.iotsitewise.model.BatchGetAssetPropertyValueSuccessEntry.ReadOnly =
    new Wrapper(impl)
}
