package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.ErrorMessage
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchPutAssetPropertyError(
    errorCode: zio.aws.iotsitewise.model.BatchPutAssetPropertyValueErrorCode,
    errorMessage: ErrorMessage,
    timestamps: Iterable[zio.aws.iotsitewise.model.TimeInNanos]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyError = {
    import BatchPutAssetPropertyError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyError
      .builder()
      .errorCode(errorCode.unwrap)
      .errorMessage(ErrorMessage.unwrap(errorMessage): java.lang.String)
      .timestamps(timestamps.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.BatchPutAssetPropertyError.ReadOnly =
    zio.aws.iotsitewise.model.BatchPutAssetPropertyError.wrap(buildAwsValue())
}
object BatchPutAssetPropertyError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.BatchPutAssetPropertyError =
      zio.aws.iotsitewise.model.BatchPutAssetPropertyError(
        errorCode,
        errorMessage,
        timestamps.map { item =>
          item.asEditable
        }
      )
    def errorCode: zio.aws.iotsitewise.model.BatchPutAssetPropertyValueErrorCode
    def errorMessage: ErrorMessage
    def timestamps: List[zio.aws.iotsitewise.model.TimeInNanos.ReadOnly]
    def getErrorCode: ZIO[
      Any,
      Nothing,
      zio.aws.iotsitewise.model.BatchPutAssetPropertyValueErrorCode
    ] = ZIO.succeed(errorCode)
    def getErrorMessage: ZIO[Any, Nothing, ErrorMessage] =
      ZIO.succeed(errorMessage)
    def getTimestamps: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.TimeInNanos.ReadOnly
    ]] = ZIO.succeed(timestamps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyError
  ) extends zio.aws.iotsitewise.model.BatchPutAssetPropertyError.ReadOnly {
    override val errorCode
        : zio.aws.iotsitewise.model.BatchPutAssetPropertyValueErrorCode =
      zio.aws.iotsitewise.model.BatchPutAssetPropertyValueErrorCode
        .wrap(impl.errorCode())
    override val errorMessage: ErrorMessage =
      zio.aws.iotsitewise.model.primitives.ErrorMessage(impl.errorMessage())
    override val timestamps
        : List[zio.aws.iotsitewise.model.TimeInNanos.ReadOnly] = impl
      .timestamps()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.TimeInNanos.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyError
  ): zio.aws.iotsitewise.model.BatchPutAssetPropertyError.ReadOnly =
    new Wrapper(impl)
}
