package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchPutAssetPropertyValueRequest(
    entries: Iterable[zio.aws.iotsitewise.model.PutAssetPropertyValueEntry]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueRequest = {
    import BatchPutAssetPropertyValueRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueRequest
      .builder()
      .entries(entries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.BatchPutAssetPropertyValueRequest.ReadOnly =
    zio.aws.iotsitewise.model.BatchPutAssetPropertyValueRequest
      .wrap(buildAwsValue())
}
object BatchPutAssetPropertyValueRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.BatchPutAssetPropertyValueRequest =
      zio.aws.iotsitewise.model.BatchPutAssetPropertyValueRequest(entries.map {
        item =>
          item.asEditable
      })
    def entries
        : List[zio.aws.iotsitewise.model.PutAssetPropertyValueEntry.ReadOnly]
    def getEntries: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.PutAssetPropertyValueEntry.ReadOnly
    ]] = ZIO.succeed(entries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueRequest
  ) extends zio.aws.iotsitewise.model.BatchPutAssetPropertyValueRequest.ReadOnly {
    override val entries
        : List[zio.aws.iotsitewise.model.PutAssetPropertyValueEntry.ReadOnly] =
      impl
        .entries()
        .asScala
        .map { item =>
          zio.aws.iotsitewise.model.PutAssetPropertyValueEntry.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueRequest
  ): zio.aws.iotsitewise.model.BatchPutAssetPropertyValueRequest.ReadOnly =
    new Wrapper(impl)
}
