package zio.aws.iotsitewise.model
import scala.jdk.CollectionConverters.*
sealed trait CapabilitySyncStatus {
  def unwrap
      : software.amazon.awssdk.services.iotsitewise.model.CapabilitySyncStatus
}
object CapabilitySyncStatus {
  def wrap(
      value: software.amazon.awssdk.services.iotsitewise.model.CapabilitySyncStatus
  ): zio.aws.iotsitewise.model.CapabilitySyncStatus = value match {
    case software.amazon.awssdk.services.iotsitewise.model.CapabilitySyncStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotsitewise.model.CapabilitySyncStatus.IN_SYNC =>
      val r = IN_SYNC
      r
    case software.amazon.awssdk.services.iotsitewise.model.CapabilitySyncStatus.OUT_OF_SYNC =>
      val r = OUT_OF_SYNC
      r
    case software.amazon.awssdk.services.iotsitewise.model.CapabilitySyncStatus.SYNC_FAILED =>
      val r = SYNC_FAILED
      r
    case software.amazon.awssdk.services.iotsitewise.model.CapabilitySyncStatus.UNKNOWN =>
      val r = UNKNOWN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotsitewise.model.CapabilitySyncStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.CapabilitySyncStatus =
      software.amazon.awssdk.services.iotsitewise.model.CapabilitySyncStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_SYNC extends zio.aws.iotsitewise.model.CapabilitySyncStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.CapabilitySyncStatus =
      software.amazon.awssdk.services.iotsitewise.model.CapabilitySyncStatus.IN_SYNC
  }
  case object OUT_OF_SYNC
      extends zio.aws.iotsitewise.model.CapabilitySyncStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.CapabilitySyncStatus =
      software.amazon.awssdk.services.iotsitewise.model.CapabilitySyncStatus.OUT_OF_SYNC
  }
  case object SYNC_FAILED
      extends zio.aws.iotsitewise.model.CapabilitySyncStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.CapabilitySyncStatus =
      software.amazon.awssdk.services.iotsitewise.model.CapabilitySyncStatus.SYNC_FAILED
  }
  case object UNKNOWN extends zio.aws.iotsitewise.model.CapabilitySyncStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.CapabilitySyncStatus =
      software.amazon.awssdk.services.iotsitewise.model.CapabilitySyncStatus.UNKNOWN
  }
}
