package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.Name
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CompositeModelProperty(
    name: Name,
    `type`: Name,
    assetProperty: zio.aws.iotsitewise.model.Property
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.CompositeModelProperty = {
    import CompositeModelProperty.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.CompositeModelProperty
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .`type`(Name.unwrap(`type`): java.lang.String)
      .assetProperty(assetProperty.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.CompositeModelProperty.ReadOnly =
    zio.aws.iotsitewise.model.CompositeModelProperty.wrap(buildAwsValue())
}
object CompositeModelProperty {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.CompositeModelProperty
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.CompositeModelProperty =
      zio.aws.iotsitewise.model
        .CompositeModelProperty(name, `type`, assetProperty.asEditable)
    def name: Name
    def `type`: Name
    def assetProperty: zio.aws.iotsitewise.model.Property.ReadOnly
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getType: ZIO[Any, Nothing, Name] = ZIO.succeed(`type`)
    def getAssetProperty
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.Property.ReadOnly] =
      ZIO.succeed(assetProperty)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.CompositeModelProperty
  ) extends zio.aws.iotsitewise.model.CompositeModelProperty.ReadOnly {
    override val name: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.name())
    override val `type`: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.`type`())
    override val assetProperty: zio.aws.iotsitewise.model.Property.ReadOnly =
      zio.aws.iotsitewise.model.Property.wrap(impl.assetProperty())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.CompositeModelProperty
  ): zio.aws.iotsitewise.model.CompositeModelProperty.ReadOnly = new Wrapper(
    impl
  )
}
