package zio.aws.iotsitewise.model
import scala.jdk.CollectionConverters.*
sealed trait ComputeLocation {
  def unwrap: software.amazon.awssdk.services.iotsitewise.model.ComputeLocation
}
object ComputeLocation {
  def wrap(
      value: software.amazon.awssdk.services.iotsitewise.model.ComputeLocation
  ): zio.aws.iotsitewise.model.ComputeLocation = value match {
    case software.amazon.awssdk.services.iotsitewise.model.ComputeLocation.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotsitewise.model.ComputeLocation.EDGE =>
      val r = EDGE
      r
    case software.amazon.awssdk.services.iotsitewise.model.ComputeLocation.CLOUD =>
      val r = CLOUD
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotsitewise.model.ComputeLocation {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.ComputeLocation =
      software.amazon.awssdk.services.iotsitewise.model.ComputeLocation.UNKNOWN_TO_SDK_VERSION
  }
  case object EDGE extends zio.aws.iotsitewise.model.ComputeLocation {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.ComputeLocation =
      software.amazon.awssdk.services.iotsitewise.model.ComputeLocation.EDGE
  }
  case object CLOUD extends zio.aws.iotsitewise.model.ComputeLocation {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.ComputeLocation =
      software.amazon.awssdk.services.iotsitewise.model.ComputeLocation.CLOUD
  }
}
