package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.ErrorMessage
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ConfigurationErrorDetails(
    code: zio.aws.iotsitewise.model.ErrorCode,
    message: ErrorMessage
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ConfigurationErrorDetails = {
    import ConfigurationErrorDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ConfigurationErrorDetails
      .builder()
      .code(code.unwrap)
      .message(ErrorMessage.unwrap(message): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.ConfigurationErrorDetails.ReadOnly =
    zio.aws.iotsitewise.model.ConfigurationErrorDetails.wrap(buildAwsValue())
}
object ConfigurationErrorDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ConfigurationErrorDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ConfigurationErrorDetails =
      zio.aws.iotsitewise.model.ConfigurationErrorDetails(code, message)
    def code: zio.aws.iotsitewise.model.ErrorCode
    def message: ErrorMessage
    def getCode: ZIO[Any, Nothing, zio.aws.iotsitewise.model.ErrorCode] =
      ZIO.succeed(code)
    def getMessage: ZIO[Any, Nothing, ErrorMessage] = ZIO.succeed(message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ConfigurationErrorDetails
  ) extends zio.aws.iotsitewise.model.ConfigurationErrorDetails.ReadOnly {
    override val code: zio.aws.iotsitewise.model.ErrorCode =
      zio.aws.iotsitewise.model.ErrorCode.wrap(impl.code())
    override val message: ErrorMessage =
      zio.aws.iotsitewise.model.primitives.ErrorMessage(impl.message())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ConfigurationErrorDetails
  ): zio.aws.iotsitewise.model.ConfigurationErrorDetails.ReadOnly = new Wrapper(
    impl
  )
}
