package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{ARN, ID}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateAssetModelResponse(
    assetModelId: ID,
    assetModelArn: ARN,
    assetModelStatus: zio.aws.iotsitewise.model.AssetModelStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.CreateAssetModelResponse = {
    import CreateAssetModelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.CreateAssetModelResponse
      .builder()
      .assetModelId(ID.unwrap(assetModelId): java.lang.String)
      .assetModelArn(ARN.unwrap(assetModelArn): java.lang.String)
      .assetModelStatus(assetModelStatus.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.CreateAssetModelResponse.ReadOnly =
    zio.aws.iotsitewise.model.CreateAssetModelResponse.wrap(buildAwsValue())
}
object CreateAssetModelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.CreateAssetModelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.CreateAssetModelResponse =
      zio.aws.iotsitewise.model.CreateAssetModelResponse(
        assetModelId,
        assetModelArn,
        assetModelStatus.asEditable
      )
    def assetModelId: ID
    def assetModelArn: ARN
    def assetModelStatus: zio.aws.iotsitewise.model.AssetModelStatus.ReadOnly
    def getAssetModelId: ZIO[Any, Nothing, ID] = ZIO.succeed(assetModelId)
    def getAssetModelArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(assetModelArn)
    def getAssetModelStatus: ZIO[
      Any,
      Nothing,
      zio.aws.iotsitewise.model.AssetModelStatus.ReadOnly
    ] = ZIO.succeed(assetModelStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreateAssetModelResponse
  ) extends zio.aws.iotsitewise.model.CreateAssetModelResponse.ReadOnly {
    override val assetModelId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.assetModelId())
    override val assetModelArn: ARN =
      zio.aws.iotsitewise.model.primitives.ARN(impl.assetModelArn())
    override val assetModelStatus
        : zio.aws.iotsitewise.model.AssetModelStatus.ReadOnly =
      zio.aws.iotsitewise.model.AssetModelStatus.wrap(impl.assetModelStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreateAssetModelResponse
  ): zio.aws.iotsitewise.model.CreateAssetModelResponse.ReadOnly = new Wrapper(
    impl
  )
}
