package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{ARN, ID}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateGatewayResponse(gatewayId: ID, gatewayArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.CreateGatewayResponse = {
    import CreateGatewayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.CreateGatewayResponse
      .builder()
      .gatewayId(ID.unwrap(gatewayId): java.lang.String)
      .gatewayArn(ARN.unwrap(gatewayArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.CreateGatewayResponse.ReadOnly =
    zio.aws.iotsitewise.model.CreateGatewayResponse.wrap(buildAwsValue())
}
object CreateGatewayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.CreateGatewayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.CreateGatewayResponse =
      zio.aws.iotsitewise.model.CreateGatewayResponse(gatewayId, gatewayArn)
    def gatewayId: ID
    def gatewayArn: ARN
    def getGatewayId: ZIO[Any, Nothing, ID] = ZIO.succeed(gatewayId)
    def getGatewayArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(gatewayArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreateGatewayResponse
  ) extends zio.aws.iotsitewise.model.CreateGatewayResponse.ReadOnly {
    override val gatewayId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.gatewayId())
    override val gatewayArn: ARN =
      zio.aws.iotsitewise.model.primitives.ARN(impl.gatewayArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreateGatewayResponse
  ): zio.aws.iotsitewise.model.CreateGatewayResponse.ReadOnly = new Wrapper(
    impl
  )
}
