package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{
  TagValue,
  Description,
  ClientToken,
  Name,
  ID,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateProjectRequest(
    portalId: ID,
    projectName: Name,
    projectDescription: Optional[Description] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.CreateProjectRequest = {
    import CreateProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.CreateProjectRequest
      .builder()
      .portalId(ID.unwrap(portalId): java.lang.String)
      .projectName(Name.unwrap(projectName): java.lang.String)
      .optionallyWith(
        projectDescription.map(value =>
          Description.unwrap(value): java.lang.String
        )
      )(_.projectDescription)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.CreateProjectRequest.ReadOnly =
    zio.aws.iotsitewise.model.CreateProjectRequest.wrap(buildAwsValue())
}
object CreateProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.CreateProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.CreateProjectRequest =
      zio.aws.iotsitewise.model.CreateProjectRequest(
        portalId,
        projectName,
        projectDescription.map(value => value),
        clientToken.map(value => value),
        tags.map(value => value)
      )
    def portalId: ID
    def projectName: Name
    def projectDescription: Optional[Description]
    def clientToken: Optional[ClientToken]
    def tags: Optional[Map[TagKey, TagValue]]
    def getPortalId: ZIO[Any, Nothing, ID] = ZIO.succeed(portalId)
    def getProjectName: ZIO[Any, Nothing, Name] = ZIO.succeed(projectName)
    def getProjectDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("projectDescription", projectDescription)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreateProjectRequest
  ) extends zio.aws.iotsitewise.model.CreateProjectRequest.ReadOnly {
    override val portalId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.portalId())
    override val projectName: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.projectName())
    override val projectDescription: Optional[Description] =
      zio.aws.core.internal
        .optionalFromNullable(impl.projectDescription())
        .map(value => zio.aws.iotsitewise.model.primitives.Description(value))
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.iotsitewise.model.primitives.ClientToken(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iotsitewise.model.primitives.TagKey(
              key
            ) -> zio.aws.iotsitewise.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreateProjectRequest
  ): zio.aws.iotsitewise.model.CreateProjectRequest.ReadOnly = new Wrapper(impl)
}
