package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{ClientToken, ID}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteAccessPolicyRequest(
    accessPolicyId: ID,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DeleteAccessPolicyRequest = {
    import DeleteAccessPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DeleteAccessPolicyRequest
      .builder()
      .accessPolicyId(ID.unwrap(accessPolicyId): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.DeleteAccessPolicyRequest.ReadOnly =
    zio.aws.iotsitewise.model.DeleteAccessPolicyRequest.wrap(buildAwsValue())
}
object DeleteAccessPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DeleteAccessPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DeleteAccessPolicyRequest =
      zio.aws.iotsitewise.model.DeleteAccessPolicyRequest(
        accessPolicyId,
        clientToken.map(value => value)
      )
    def accessPolicyId: ID
    def clientToken: Optional[ClientToken]
    def getAccessPolicyId: ZIO[Any, Nothing, ID] = ZIO.succeed(accessPolicyId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DeleteAccessPolicyRequest
  ) extends zio.aws.iotsitewise.model.DeleteAccessPolicyRequest.ReadOnly {
    override val accessPolicyId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.accessPolicyId())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.iotsitewise.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DeleteAccessPolicyRequest
  ): zio.aws.iotsitewise.model.DeleteAccessPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
