package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.ID
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeProjectRequest(projectId: ID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DescribeProjectRequest = {
    import DescribeProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DescribeProjectRequest
      .builder()
      .projectId(ID.unwrap(projectId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.DescribeProjectRequest.ReadOnly =
    zio.aws.iotsitewise.model.DescribeProjectRequest.wrap(buildAwsValue())
}
object DescribeProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DescribeProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DescribeProjectRequest =
      zio.aws.iotsitewise.model.DescribeProjectRequest(projectId)
    def projectId: ID
    def getProjectId: ZIO[Any, Nothing, ID] = ZIO.succeed(projectId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeProjectRequest
  ) extends zio.aws.iotsitewise.model.DescribeProjectRequest.ReadOnly {
    override val projectId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.projectId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeProjectRequest
  ): zio.aws.iotsitewise.model.DescribeProjectRequest.ReadOnly = new Wrapper(
    impl
  )
}
